/* ============ */
/* serltst.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <miscdefs.h>
#include <serldefs.h>
#include <mconf.h>

#define	NUM_PROBS	100
#define LOW_PROB	1.0e-8

static	SERIAL_DATA_STRU SerialData;
static	INIT_DATA_STRU   InitialData;

#define	FULL_SIZE  ((unsigned)RAND_MAX + 1U)
UINT WorkArea[FULL_SIZE];

/* ==================================================================== */
/* SerialTest - Executes Serial Test per Knuth, Vol 2 (1981), p. 60	*/
/* ==================================================================== */
void
main(void)
{
    int	    k;
    long    TotVariates = 0;
    double  DegFree, LoLimit, HiLimit;
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    double  ChiSqProb[NUM_PROBS];

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\tS E R I A L  T E S T\n\n");
    GetInitialData(&InitialData);

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("\nStarting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);

    /* -------------------------------------- */
    /* Set Address of Random Number Generator */
    /* -------------------------------------- */
    SerialData.RandFun = InitialData.RandFun;

    /* --------------------------------------------- */
    /* Initialize Control Parameters for Serial Test */
    /* --------------------------------------------- */
    SetSerialControls(&SerialData);

    /* -------------------------- */
    /* Initialize Variate Counter */
    /* -------------------------- */
    SerialData.TotNumGen = 0;

    DegFree = SerialData.NumCategories - 1;
    ChiSqDist(LOW_PROB, DegFree, &LoLimit, &HiLimit);

    fflush(NULL);
    /* ------------------------- */
    /* Generate Random Numbers,  */
    /* Calculate Chi-Square Data */
    /* ------------------------- */
    for (k = 0; k < NUM_PROBS; ++k)
    {
	CalcSerialChiSq(&SerialData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, SerialData.TotNumGen);

	if (SerialData.SerialChiSq <= LoLimit)
	{
	    ChiSqProb[k] = LOW_PROB;
	}
	else if (SerialData.SerialChiSq >= HiLimit)
	{
	    ChiSqProb[k] = 1.0 - LOW_PROB;
	}
	else
	{
	    ChiSqProb[k] = chdtr(DegFree, SerialData.SerialChiSq);
	}
	if (ChiSqProb[k] < 0)
	{
	    fprintf(stderr, "\nChiSqFreq(): Function chdtr() "
		"Returned Negative Probability -  Can't Happen.\n");
	}
	P(printf("Serial Chi-Square Statistic = %f\n",
	   SerialData.SerialChiSq));
	P(printf("Chi-Square Probability on %.f"
		" Degrees of Freedom = %.4f\n", DegFree, ChiSqProb[k]));
    }

    /* -------------------------------------------------------- */
    /* Calculate K-S on Chi-Square Statistics and Probabilities */
    /* -------------------------------------------------------- */
    fflush(NULL);
    KSCalc(ChiSqProb, NUM_PROBS,
		&KnPlusStat, &KnPlusProb,
 		&KnMinusStat, &KnMinusProb);

   printf("\n\nKolmogorov-Smirnov Statistics and Probabilities"
	" on Chi-Square Data\n");

   printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnPlusStat, 100*KnPlusProb);

   printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnMinusStat, 100*KnMinusProb);

    printf("\nThis Run Required %ld Random Numbers\n",
	SerialData.TotNumGen);
}
